/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.sdf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5425;
import ru.bclib.sdf.PosInfo;
import ru.bclib.util.BlocksHelper;
import ru.bclib.world.structures.StructureWorld;

public abstract class SDF {
    private List<Function<PosInfo, class_2680>> postProcesses = Lists.newArrayList();
    private Function<class_2680, Boolean> canReplace = state -> state.method_26207().method_15800();

    public abstract float getDistance(float var1, float var2, float var3);

    public abstract class_2680 getBlockState(class_2338 var1);

    public SDF addPostProcess(Function<PosInfo, class_2680> postProcess) {
        this.postProcesses.add(postProcess);
        return this;
    }

    public SDF setReplaceFunction(Function<class_2680, Boolean> canReplace) {
        this.canReplace = canReplace;
        return this;
    }

    public void fillRecursive(class_5425 world, class_2338 start) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new class_2338(0, 0, 0));
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (class_2338 center : ends) {
                for (class_2350 dir : class_2350.values()) {
                    bPos.method_10101((class_2382)center).method_10098(dir);
                    class_2338 wpos = bPos.method_10081((class_2382)start);
                    if (blocks.contains(bPos) || !this.canReplace.apply(world.method_8320(wpos)).booleanValue() || !(this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0.0f)) continue;
                    class_2680 state = this.getBlockState(wpos);
                    PosInfo.create(mapWorld, addInfo, wpos).setState(state);
                    add.add(bPos.method_10062());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
            infos.forEach(info -> BlocksHelper.setWithoutUpdate((class_1936)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.method_8320(info.getPos())).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillArea(class_5425 world, class_2338 center, class_238 box) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        class_2338.class_2339 mut = new class_2338.class_2339();
        int y = (int)box.field_1322;
        while ((double)y <= box.field_1325) {
            mut.method_33098(y);
            int x = (int)box.field_1323;
            while ((double)x <= box.field_1320) {
                mut.method_33097(x);
                int z = (int)box.field_1321;
                while ((double)z <= box.field_1324) {
                    class_2338 fpos;
                    mut.method_33099(z);
                    if (this.canReplace.apply(world.method_8320((class_2338)mut)).booleanValue() && this.getDistance((fpos = mut.method_10059((class_2382)center)).method_10263(), fpos.method_10264(), fpos.method_10260()) < 0.0f) {
                        PosInfo.create(mapWorld, addInfo, mut.method_10062()).setState(this.getBlockState((class_2338)mut));
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
            infos.forEach(info -> BlocksHelper.setWithoutUpdate((class_1936)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.method_8320(info.getPos())).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillRecursiveIgnore(class_5425 world, class_2338 start, Function<class_2680, Boolean> ignore) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new class_2338(0, 0, 0));
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (class_2338 center : ends) {
                for (class_2350 dir : class_2350.values()) {
                    bPos.method_10101((class_2382)center).method_10098(dir);
                    class_2338 wpos = bPos.method_10081((class_2382)start);
                    class_2680 state = world.method_8320(wpos);
                    boolean ign = ignore.apply(state);
                    if (blocks.contains(bPos) || !ign && !this.canReplace.apply(state).booleanValue() || !(this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0.0f)) continue;
                    PosInfo.create(mapWorld, addInfo, wpos).setState(ign ? state : this.getBlockState((class_2338)bPos));
                    add.add(bPos.method_10062());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
            infos.forEach(info -> BlocksHelper.setWithoutUpdate((class_1936)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.method_8320(info.getPos())).booleanValue()) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillRecursive(StructureWorld world, class_2338 start) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new class_2338(0, 0, 0));
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (class_2338 center : ends) {
                for (class_2350 dir : class_2350.values()) {
                    bPos.method_10101((class_2382)center).method_10098(dir);
                    class_2338 wpos = bPos.method_10081((class_2382)start);
                    if (blocks.contains(bPos) || !(this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0.0f)) continue;
                    class_2680 state = this.getBlockState(wpos);
                    PosInfo.create(mapWorld, addInfo, wpos).setState(state);
                    add.add(bPos.method_10062());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        Collections.sort(infos);
        this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
        infos.forEach(info -> world.setBlock(info.getPos(), info.getState()));
        infos.clear();
        infos.addAll(addInfo.values());
        Collections.sort(infos);
        this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((class_2680)postProcess.apply(info))));
        infos.forEach(info -> world.setBlock(info.getPos(), info.getState()));
    }

    public Set<class_2338> getPositions(class_5425 world, class_2338 start) {
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new class_2338(0, 0, 0));
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (class_2338 center : ends) {
                for (class_2350 dir : class_2350.values()) {
                    bPos.method_10101((class_2382)center).method_10098(dir);
                    class_2338 wpos = bPos.method_10081((class_2382)start);
                    class_2680 state = world.method_8320(wpos);
                    if (blocks.contains(wpos) || !this.canReplace.apply(state).booleanValue() || !(this.getDistance(bPos.method_10263(), bPos.method_10264(), bPos.method_10260()) < 0.0f)) continue;
                    add.add(bPos.method_10062());
                }
            }
            ends.forEach(end -> blocks.add(end.method_10081((class_2382)start)));
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        return blocks;
    }
}

